\
<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Post;

class PostController extends Controller
{
    public function index()
    {
        return Post::query()->latest('published_at')->paginate(12);
    }

    public function showBySlug(string $slug)
    {
        $post = Post::query()->where('slug', $slug)->first();
        if (!$post) return response()->json(['message' => 'Not found'], 404);

        return response()->json($post);
    }
}
